//
//  ViewController.swift
//  MapKitDemo
//
//  Created by Krishna Subramanian on 20/12/15.
//  Copyright © 2015 Krishna Subramanian. All rights reserved.
//

import UIKit
import CoreLocation
import MapKit

class ViewController: UIViewController, CLLocationManagerDelegate, MKMapViewDelegate {
    
    let locationManager = CLLocationManager()
    @IBOutlet weak var mapView: MKMapView!

    override func viewDidLoad() {
        super.viewDidLoad()
        
        self.locationManager.delegate = self
        self.mapView.delegate = self
        
        self.mapView.mapType = MKMapType.Satellite // Standard, Satellite, Hybrid, ...
        
        // Set map region
        let Aachen = CLLocationCoordinate2D(latitude: 50.774362, longitude: 6.088964)
        self.mapView.region = MKCoordinateRegionMakeWithDistance(Aachen, 1000, 1000)
    }
    
    @IBAction func createSimplePointAnnotation(sender: AnyObject) {
        let RWTHMainBuilding = CLLocationCoordinate2D(latitude: 50.777773, longitude: 6.077992)
        
        let simplePointAnnotation = MKPointAnnotation()
        
        simplePointAnnotation.coordinate = RWTHMainBuilding
        simplePointAnnotation.title = "Main Building of RWTH"
        simplePointAnnotation.subtitle = "Templergraben 55, 52062 Aachen"
        
        self.mapView.addAnnotation(simplePointAnnotation)
        
        // Move map region
        self.mapView.setCenterCoordinate(RWTHMainBuilding, animated: true)
    }
    
    @IBAction func createCustomPointAnnotation(sender: AnyObject) {
        let InformatikZentrum = CLLocationCoordinate2D(latitude: 50.779419, longitude: 6.059010)
        
        let customPointAnnotation = MKPointAnnotation()
        
        customPointAnnotation.coordinate = InformatikZentrum
        customPointAnnotation.title = "Computer Science Building"
        customPointAnnotation.subtitle = "Ahornstrasse 55, 52074 Aachen"
        
        self.mapView.addAnnotation(customPointAnnotation)
        
        // Move map region
        self.mapView.setCenterCoordinate(InformatikZentrum, animated: true)
    }
    
    
    @IBAction func createImageAnnotation(sender: AnyObject) {
        let AachenerDom = CLLocationCoordinate2D(latitude: 50.774783, longitude: 6.083920)
        
        let imageAnnotation = MKPointAnnotation()
        
        imageAnnotation.coordinate = AachenerDom
        imageAnnotation.title = "Aachener Dom"
        imageAnnotation.subtitle = "Domhof 1, 52062 Aachen"
        
        self.mapView.addAnnotation(imageAnnotation)
        
        // Move map region
        self.mapView.setCenterCoordinate(AachenerDom, animated: true)
    }
    
    func mapView(mapView: MKMapView, viewForAnnotation annotation: MKAnnotation) -> MKAnnotationView? {
        if annotation.title! == "Computer Science Building" {
            let aView = MKPinAnnotationView.init(annotation: annotation, reuseIdentifier: "InformatikZentrum")
            
            aView.pinTintColor = UIColor.blueColor()
            aView.animatesDrop = true
            
            return aView
        } else if annotation.title! == "Aachener Dom" {
            let aView = MKAnnotationView.init(annotation: annotation, reuseIdentifier: "AachenerDom")
            
            aView.image = UIImage.init(named: "dom")
            aView.centerOffset = CGPoint.init(x: -50, y: 50)
            
            return aView
        }
        
        return nil
    }
    
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }


}

